package fr.asip.cps3.exemple.vues.menus;

import java.awt.event.ActionListener;
import fr.asip.cps3.exemple.modele.objets.Cle;

/**
 * Classe modlisant un item de menu de type Cle
 *
 */
public class ItemMenuCle extends ItemMenu {
	
	private static final long serialVersionUID = 3647766703109678404L;
	
	/**
	 * Cl associe  l'item de menu
	 */
	private Cle cle;

	/**
	 * Constructeur  5 arguments
	 * @param cle Cl associe  l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuCle(Cle cle,String idParent, boolean enable, boolean visible, ActionListener ecouteur) {
		
		super(idParent+",", idParent, "", enable, visible, ecouteur);
		this.cle = cle;
		if(cle != null) {
			setId(getIdParent()+","+cle.getIdCle());
			setText(cle.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Cl associe  l'item de menu
	 */
	public Cle getCle() {
		return cle;
	}


	
}
